/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vistara.sdk.dto.Client;
import com.vistara.sdk.dto.response.Response;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.APITemplate;
import com.vistara.sdk.utils.SdkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAPI
implements APIConstants {
    private static Logger logger = LoggerFactory.getLogger(ClientAPI.class);
    static String OK = "200";
    private String apiBaseURI = null;

    public static Client getClient(String clientId, String partnerId) throws Exception {
        String URI2 = ClientAPI.getClientURI(clientId, partnerId);
        try {
            Response res;
            String jsonData = APITemplate.getInstance(clientId).getRequest(URI2);
            if (jsonData != null && (res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){})) != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                return (Client)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<Client>(){});
            }
        }
        catch (Exception e) {
            logger.error("@ Fetching Resource data for URI:" + URI2);
            throw e;
        }
        return null;
    }

    public static String getClientURI(String clientId, String partnerId) {
        StringBuilder sb = new StringBuilder();
        sb.append("tenants/");
        sb.append(partnerId).append("/");
        sb.append("clients").append("/");
        sb.append(clientId);
        return sb.toString();
    }

    public String getClientListURI(String authType, String partnerId) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + partnerId + "/clients/minimal";
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + partnerId + "/clients/minimal";
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + authType);
            }
        }
        return apiURL;
    }

    public String getApiBaseURI() {
        if (this.apiBaseURI == null) {
            return "https://api.vistara.io";
        }
        return this.apiBaseURI;
    }
}

