/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.vistara.sdk.dto.MultiChoiceFieldValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomField
implements Serializable {
    private String id;
    private String classCode;
    private String displayLabel;
    private String name;
    private String fieldType;
    private boolean mandatory = false;
    private boolean editable = true;
    private String description;
    private List<MultiChoiceFieldValue> options;
    private String value;
    private MultiChoiceFieldValue selectedOption;

    public CustomField() {
    }

    public CustomField(String id, String name, String displayLabel, boolean editable, boolean mandatory, String description, String fieldType, String classCode) {
        this.id = id;
        this.name = name;
        this.displayLabel = displayLabel;
        this.editable = editable;
        this.mandatory = mandatory;
        this.description = description;
        this.fieldType = fieldType;
        this.classCode = classCode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @XmlElement(name="type")
    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    @XmlElementWrapper(name="options")
    @XmlElement(name="option")
    public List<MultiChoiceFieldValue> getOptions() {
        return this.options;
    }

    public void setOptions(List<MultiChoiceFieldValue> options) {
        this.options = options;
    }

    public void addOption(MultiChoiceFieldValue option) {
        if (this.options == null) {
            this.options = new ArrayList<MultiChoiceFieldValue>();
        }
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public MultiChoiceFieldValue getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(MultiChoiceFieldValue selectedOption) {
        this.selectedOption = selectedOption;
    }
}

