/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimeUtils {
    public static final String API_DATE_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String DB_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] possibleISODateFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy'T'HH:mm:ss.SSS'Z'", "MM/dd/yyyy'T'HH:mm:ss.SSSZ", "MM/dd/yyyy'T'HH:mm:ss.SSS", "MM/dd/yyyy'T'HH:mm:ssZ", "MM/dd/yyyy'T'HH:mm:ss", "yyyy:MM:dd HH:mm:ss", "yyyyMMdd"};

    public static Date convertStringToDateWithISODateFormat(String dateStr) {
        Date date = null;
        if (dateStr == null || dateStr.isEmpty()) {
            return date;
        }
        for (String pattern : possibleISODateFormats) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            try {
                date = sdf.parse(dateStr);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        return date;
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            return "";
        }
        df = new SimpleDateFormat(aMask);
        returnValue = df.format(aDate);
        return returnValue;
    }

    public static final String getDateTimeByTimeInMilliSec(String aMask, long milliSec) {
        if (milliSec <= 0L) {
            return "";
        }
        Date date = new Date(milliSec);
        return TimeUtils.getDateTime(aMask, date);
    }

    public static final String getDateTimeByTimeInSec(String aMask, long sec) {
        if (sec <= 0L) {
            return "";
        }
        return TimeUtils.getDateTimeByTimeInMilliSec(aMask, sec * 1000L);
    }

    public static String convertStringToDateStringWithPattern(String strDate) throws ParseException {
        SimpleDateFormat sdfSource = new SimpleDateFormat(DB_DATE_FORMAT);
        SimpleDateFormat sdfDestination = new SimpleDateFormat(API_DATE_FORMAT_ISO8601);
        Date date = null;
        try {
            date = sdfSource.parse(strDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sdfDestination.format(date);
    }

    public static final Date convertDateToGMT(Date date, TimeZone tz) {
        if (date == null || tz == null) {
            return date;
        }
        long time = date.getTime();
        GregorianCalendar cal = TimeUtils.toGregorianCalendar(date, tz);
        long offset = cal.get(15) + cal.get(16);
        long gmtTime = time - offset;
        return new Date(gmtTime);
    }

    private static GregorianCalendar toGregorianCalendar(Date date, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.setTimeZone(tz);
        return cal;
    }
}

