/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.awt.Color;
import java.util.Arrays;
import org.apache.poi.ss.usermodel.ExtendedColor;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.util.Internal;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;

public class XSSFColor
extends ExtendedColor {
    private final CTColor ctColor;

    public XSSFColor(CTColor color) {
        this.ctColor = color;
    }

    public XSSFColor() {
        this.ctColor = CTColor.Factory.newInstance();
    }

    public XSSFColor(Color clr) {
        this();
        this.setColor(clr);
    }

    public XSSFColor(byte[] rgb) {
        this();
        this.ctColor.setRgb(rgb);
    }

    public XSSFColor(IndexedColors indexedColor) {
        this();
        this.ctColor.setIndexed(indexedColor.index);
    }

    @Override
    public boolean isAuto() {
        return this.ctColor.getAuto();
    }

    public void setAuto(boolean auto) {
        this.ctColor.setAuto(auto);
    }

    @Override
    public boolean isIndexed() {
        return this.ctColor.isSetIndexed();
    }

    @Override
    public boolean isRGB() {
        return this.ctColor.isSetRgb();
    }

    @Override
    public boolean isThemed() {
        return this.ctColor.isSetTheme();
    }

    public boolean hasAlpha() {
        if (!this.ctColor.isSetRgb()) {
            return false;
        }
        return this.ctColor.getRgb().length == 4;
    }

    public boolean hasTint() {
        if (!this.ctColor.isSetTint()) {
            return false;
        }
        return this.ctColor.getTint() != 0.0;
    }

    @Override
    public short getIndex() {
        return (short)this.ctColor.getIndexed();
    }

    public short getIndexed() {
        return this.getIndex();
    }

    public void setIndexed(int indexed) {
        this.ctColor.setIndexed(indexed);
    }

    @Override
    public byte[] getRGB() {
        byte[] rgb = this.getRGBOrARGB();
        if (rgb == null) {
            return null;
        }
        if (rgb.length == 4) {
            byte[] tmp = new byte[3];
            System.arraycopy(rgb, 1, tmp, 0, 3);
            return tmp;
        }
        return rgb;
    }

    @Override
    public byte[] getARGB() {
        byte[] rgb = this.getRGBOrARGB();
        if (rgb == null) {
            return null;
        }
        if (rgb.length == 3) {
            byte[] tmp = new byte[4];
            tmp[0] = -1;
            System.arraycopy(rgb, 0, tmp, 1, 3);
            return tmp;
        }
        return rgb;
    }

    @Override
    protected byte[] getStoredRBG() {
        return this.ctColor.getRgb();
    }

    @Override
    public void setRGB(byte[] rgb) {
        this.ctColor.setRgb(rgb);
    }

    @Override
    public int getTheme() {
        return (int)this.ctColor.getTheme();
    }

    public void setTheme(int theme) {
        this.ctColor.setTheme(theme);
    }

    @Override
    public double getTint() {
        return this.ctColor.getTint();
    }

    @Override
    public void setTint(double tint) {
        this.ctColor.setTint(tint);
    }

    @Internal
    public CTColor getCTColor() {
        return this.ctColor;
    }

    public static XSSFColor toXSSFColor(org.apache.poi.ss.usermodel.Color color) {
        if (color != null && !(color instanceof XSSFColor)) {
            throw new IllegalArgumentException("Only XSSFColor objects are supported");
        }
        return (XSSFColor)color;
    }

    public int hashCode() {
        return this.ctColor.toString().hashCode();
    }

    private boolean sameIndexed(XSSFColor other) {
        if (this.isIndexed() == other.isIndexed()) {
            if (this.isIndexed()) {
                return this.getIndexed() == other.getIndexed();
            }
            return true;
        }
        return false;
    }

    private boolean sameARGB(XSSFColor other) {
        if (this.isRGB() == other.isRGB()) {
            if (this.isRGB()) {
                return Arrays.equals(this.getARGB(), other.getARGB());
            }
            return true;
        }
        return false;
    }

    private boolean sameTheme(XSSFColor other) {
        if (this.isThemed() == other.isThemed()) {
            if (this.isThemed()) {
                return this.getTheme() == other.getTheme();
            }
            return true;
        }
        return false;
    }

    private boolean sameTint(XSSFColor other) {
        if (this.hasTint() == other.hasTint()) {
            if (this.hasTint()) {
                return this.getTint() == other.getTint();
            }
            return true;
        }
        return false;
    }

    private boolean sameAuto(XSSFColor other) {
        return this.isAuto() == other.isAuto();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFColor)) {
            return false;
        }
        XSSFColor other = (XSSFColor)o;
        return this.sameARGB(other) && this.sameTheme(other) && this.sameIndexed(other) && this.sameTint(other) && this.sameAuto(other);
    }
}

